
  import javafx.application.Application;
  import javafx.scene.Scene;
  import javafx.scene.layout.Pane;
  import javafx.scene.paint.Color;
  import javafx.stage.Stage;
  import javafx.event.ActionEvent;
  import javafx.util.Duration;
  import javafx.animation.KeyFrame;
   import javafx.animation.Timeline;

  public class Animation3 extends Application 
  {
     private SnowManCanvas sm1;
     private double speedX, speedY;

     public void start(Stage primaryStage) 
     {
        sm1 = new SnowManCanvas(0, 0, Color.GREEN);
        speedX = 4.0;
        speedY = speedX/2.63;
        
        KeyFrame kF1 = new KeyFrame(Duration.seconds(0.03), 
                                    e -> kF1KeyFrameHandler());
        Timeline tL1 = new Timeline(kF1);
        tL1.setCycleCount(430);
        tL1.play();
        
        Pane root = new Pane();

        root.getChildren().addAll(sm1.getCanvas());
                
        Scene scene = new Scene(root, 600, 300, Color.LIGHTGRAY);

        primaryStage.setTitle("Animation Using a Timeline");
        primaryStage.setScene(scene);
        primaryStage.show();
    }
    
    public void kF1KeyFrameHandler(ActionEvent e)
    {
      if((sm1.getCanvas().getTranslateY() >= 215.0) ||
         (sm1.getCanvas().getTranslateY() < -1))
      {
         speedX = -speedX;
         speedY = -speedY;
      }
      sm1.getCanvas().setTranslateX(sm1.getCanvas().getTranslateX() + speedX);
      sm1.getCanvas().setTranslateY(sm1.getCanvas().getTranslateY() + speedY);
    }
    
    public static void main(String[] args) 
    {
      launch(args);
    }
 }


